/*
 * Copyright Staffan Gimåker 2008-2009.
 *
 * ---
 *
 * Distributed under the Boost Software License, Version 1.0.
 * (See accompanying file LICENSE_1_0.txt or copy at
 * http://www.boost.org/LICENSE_1_0.txt)
 */

#ifndef PEEKABOT_SERIALIZATION_PAIR_HH_INCLUDED
#define PEEKABOT_SERIALIZATION_PAIR_HH_INCLUDED


#include <utility>

#include "SerializationInterface.hh"
#include "DeserializationInterface.hh"


namespace peekabot
{
    template<typename U, typename V> inline
    SerializationInterface &operator<<(
        SerializationInterface &ar, const std::pair<U, V> &x)
    {
        ar << x.first << x.second;
        return ar;
    }

    template<typename U, typename V> inline
    DeserializationInterface &operator>>(
        DeserializationInterface &ar, std::pair<U, V> &x)
    {
        ar >> x.first >> x.second;
        return ar;
    }
}


#endif // PEEKABOT_SERIALIZATION_PAIR_HH_INCLUDED
