/*
 * Copyright Staffan Gimåker 2009.
 *
 * ---
 *
 * Distributed under the Boost Software License, Version 1.0.
 * (See accompanying file LICENSE_1_0.txt or copy at
 * http://www.boost.org/LICENSE_1_0.txt)
 */

#ifndef PEEKABOT_SERIALIZATION_EIGEN_HH_INCLUDED
#define PEEKABOT_SERIALIZATION_EIGEN_HH_INCLUDED


#include "SerializationInterface.hh"
#include "DeserializationInterface.hh"

#include <Eigen/Core>
#include <Eigen/Geometry>


namespace peekabot
{
    inline SerializationInterface &operator<<(
        SerializationInterface &ar,
        const Eigen::Vector4f &x)
    {
        ar.save_array(x.data(), 4);
        return ar;
    }

    inline DeserializationInterface &operator>>(
        DeserializationInterface &ar,
        Eigen::Vector4f &x)
    {
        ar.load_array(x.data(), 4);
        return ar;
    }

    inline SerializationInterface &operator<<(
        SerializationInterface &ar,
        const Eigen::Vector3f &x)
    {
        ar.save_array(x.data(), 3);
        return ar;
    }

    inline DeserializationInterface &operator>>(
        DeserializationInterface &ar,
        Eigen::Vector3f &x)
    {
        ar.load_array(x.data(), 3);
        return ar;
    }

    inline SerializationInterface &operator<<(
        SerializationInterface &ar,
        const Eigen::Vector2f &x)
    {
        ar.save_array(x.data(), 2);
        return ar;
    }

    inline DeserializationInterface &operator>>(
        DeserializationInterface &ar,
        Eigen::Vector2f &x)
    {
        ar.load_array(x.data(), 2);
        return ar;
    }

    inline SerializationInterface &operator<<(
        SerializationInterface &ar,
        const Eigen::Matrix4f &x)
    {
        ar.save_array(x.data(), 16);
        return ar;
    }

    inline DeserializationInterface &operator>>(
        DeserializationInterface &ar,
        Eigen::Matrix4f &x)
    {
        ar.load_array(x.data(), 16);
        return ar;
    }

    inline SerializationInterface &operator<<(
        SerializationInterface &ar,
        const Eigen::Transform3f &x)
    {
        ar << x.matrix();
        return ar;
    }

    inline DeserializationInterface &operator>>(
        DeserializationInterface &ar,
        Eigen::Transform3f &x)
    {
        ar >> x.matrix();
        return ar;
    }
}


#endif // PEEKABOT_SERIALIZATION_EIGEN_HH_INCLUDED
