/*
 * Copyright Staffan Gimåker 2009.
 *
 * ---
 *
 * Distributed under the Boost Software License, Version 1.0.
 * (See accompanying file LICENSE_1_0.txt or copy at
 * http://www.boost.org/LICENSE_1_0.txt)
 */

#ifndef PEEKABOT_CHUNKED_BUFFER_ADAPTER_HH_INCLUDED
#define PEEKABOT_CHUNKED_BUFFER_ADAPTER_HH_INCLUDED


#include <stdexcept>

#include "DeserializationBuffer.hh"
#include "SerializationBuffer.hh"
#include "../ChunkedBuffer.hh"


namespace peekabot
{
    class ChunkedBufferAdapter :
        public serialization::DeserializationBuffer,
        public serialization::SerializationBuffer
    {
    public:
        ChunkedBufferAdapter(ChunkedBuffer &buf)
            : m_buf(buf)
        {
        }

        virtual void read(void *x, std::size_t n)
        {
            if( m_buf.read(x, n) != n )
                throw std::runtime_error(
                    "Failed to load data, buffer exhausted");
        }

        virtual void write(const void *x, std::size_t n)
        {
            m_buf.write(x, n);
        }

    private:
        ChunkedBuffer &m_buf;
    };
}


#endif // PEEKABOT_CHUNKED_BUFFER_ADAPTER_HH_INCLUDED
