/*
 * Copyright Staffan Gimåker 2007-2008.
 *
 * ---
 *
 * This file is part of peekabot.
 *
 * peekabot is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * peekabot is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <GL/glew.h>

#include "Texture2D.hh"


using namespace peekabot;
using namespace peekabot::renderer;
using namespace peekabot::renderer::statelets;



Texture2D::Impl::Impl(bool enable)
    : m_enable(enable)
{
}

Texture2D::Impl::Impl(boost::shared_ptr<Texture> texture, bool enable)
    : m_enable(enable),
      m_texture(texture)
{
}


void Texture2D::Impl::activate() throw()
{
    if( m_enable )
    {
        glEnable(GL_TEXTURE_2D);
        m_texture->bind();
    }
    else
    {
        glDisable(GL_TEXTURE_2D);
    }
}
