/*
 * Copyright Staffan Gimåker 2010.
 *
 * ---
 *
 * This file is part of peekabot.
 *
 * peekabot is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * peekabot is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef PEEKABOT_RENDERER_OG3D_TRAVERSAL_CONTEXT_HH_INCLUDED
#define PEEKABOT_RENDERER_OG3D_TRAVERSAL_CONTEXT_HH_INCLUDED


#include <vector>


namespace peekabot
{
    namespace renderer
    {
        class Og3dNode;

        class Og3dTraversalContext
        {
        public:
            Og3dTraversalContext(
                float cell_size, float height_factor)
                : m_cell_size(cell_size), m_hf(height_factor) {}

            inline float get_cell_size() const { return m_cell_size; }

            inline float get_height_factor() const { return m_hf; }

            inline void push_parent(Og3dNode *node)
            {
                m_path.push_back(node);
            }

            inline void pop_parent()
            {
                m_path.pop_back();
            }

            /*inline std::size_t path_len() const
            {
                return m_path.size();
            }*/

            /**
             * \brief Get the i+1:th ancestor in the current path.
             *
             * E.g. \c get_ancestor(0) will return the currently traversed
             * node's immediate parent, \c get_ancestor(1) will return its
             * grandparent, etc.
             *
             * For the parent of the root node \c get_ancestor() returns 0.
             */
            inline Og3dNode *get_ancestor(std::size_t i)
            {
                return m_path[m_path.size()-1-i];
            }

        private:
            const float m_cell_size;

            // The grid cell height factor, i.e. how tall a cell is in relation to a
            // side of its base area.
            const float m_hf;

            std::vector<Og3dNode *> m_path;
        };
    }
}


#endif // PEEKABOT_RENDERER_OG3D_TRAVERSAL_CONTEXT_HH_INCLUDED
