/*
 * Copyright Staffan Gimåker 2007-2010.
 *
 * ---
 *
 * This file is part of peekabot.
 *
 * peekabot is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * peekabot is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include "VertexBuffer.hh"
#include "Device.hh"

#include <GL/glew.h>
#include <stdexcept>


using namespace peekabot;
using namespace peekabot::renderer;


VertexBuffer::VertexBuffer(bool force_no_vbos)
    : ArrayBuffer(force_no_vbos, false)
{
}


VertexBuffer::VertexBuffer(const VertexBuffer &other)
    : ArrayBuffer(other)
{
}


void VertexBuffer::source_vertex_data(
    std::size_t size, GLenum type,
    std::size_t stride, std::size_t off) const
{
    if( is_mapped() )
        throw std::runtime_error("Can't source data from mapped buffers");

    if( uses_vbos() )
    {
        if( !is_bound() )
            bind();

        glVertexPointer(size, type, stride, (void *)off);
    }
    else
    {
        clear_vertex_buffer_vbo_binding();
        glVertexPointer(size, type, stride, (void *)(get_data()+off));
    }

    CHECK_GL_ERRORS();
}


void VertexBuffer::source_texcoord_data(
    std::size_t size, GLenum type,
    std::size_t stride, std::size_t off) const
{
    if( is_mapped() )
        throw std::runtime_error("Can't source data from mapped buffers");

    if( uses_vbos() )
    {
        if( !is_bound() )
            bind();

        glTexCoordPointer(size, type, stride, (void *)off);
    }
    else
    {
        clear_vertex_buffer_vbo_binding();
        glTexCoordPointer(size, type, stride, (void *)(get_data()+off));
    }

    CHECK_GL_ERRORS();
}


void VertexBuffer::source_normal_data(
    GLenum type, std::size_t stride, std::size_t off) const
{
    if( is_mapped() )
        throw std::runtime_error("Can't source data from mapped buffers");

    if( uses_vbos() )
    {
        if( !is_bound() )
            bind();

        glNormalPointer(type, stride, (void *)off);
    }
    else
    {
        clear_vertex_buffer_vbo_binding();
        glNormalPointer(type, stride, (void *)(get_data()+off));
    }

    CHECK_GL_ERRORS();
}


void VertexBuffer::source_color_data(
    std::size_t size, GLenum type,
    std::size_t stride, std::size_t off) const
{
    if( is_mapped() )
        throw std::runtime_error("Can't source data from mapped buffers");

    if( uses_vbos() )
    {
        if( !is_bound() )
            bind();

        glColorPointer(size, type, stride, (void *)off);
    }
    else
    {
        clear_vertex_buffer_vbo_binding();
        glColorPointer(size, type, stride, (void *)(get_data()+off));
    }

    CHECK_GL_ERRORS();
}
