/*
 * Copyright Staffan Gimåker 2008.
 *
 * ---
 *
 * This file is part of peekabot.
 *
 * peekabot is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * peekabot is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef PEEKABOT_RENDERER_SCENE_TRAVERSER_HH_INCLUDED
#define PEEKABOT_RENDERER_SCENE_TRAVERSER_HH_INCLUDED


namespace peekabot
{
    namespace renderer
    {
        class Entity;

        /**
         * \brief Interface used for traversing all potentially visible 
         * entities in a scene.
         */
        class SceneTraverser
        {
        public:
            virtual ~SceneTraverser() {}

            /**
             * \brief Called for every traversed entity the scene.
             */
            virtual void traverse(const Entity *entity) = 0;
        };
    }
}


#endif // PEEKABOT_RENDERER_SCENE_TRAVERSER_HH_INCLUDED
