/*
 * Copyright Staffan Gimåker 2008-2009.
 *
 * ---
 *
 * This file is part of peekabot.
 *
 * peekabot is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * peekabot is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef PEEKABOT_RENDERER_PREPARE_RENDER_CONTEXT_HH_INCLUDED
#define PEEKABOT_RENDERER_PREPARE_RENDER_CONTEXT_HH_INCLUDED


namespace peekabot
{
    namespace renderer
    {
        class Camera;
        class Renderable;

        class PrepareRenderContext
        {
        public:
            PrepareRenderContext(const Camera *camera)
                : m_camera(camera)
            {
            }

            virtual ~PrepareRenderContext() {}

            inline const Camera *get_camera() const throw()
            {
                return m_camera;
            }

            virtual void prepare(
                const Renderable *r, bool assume_ownership = false) = 0;

        private:
            const Camera *m_camera;
        };
    }
}


#endif // PEEKABOT_RENDERER_PREPARE_RENDER_CONTEXT_HH_INCLUDED
