/*
 * This file is part of peekabot.
 *
 * peekabot is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * peekabot is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef __PEEKABOT_RENDERER_PNG_LOADER_HH
#define __PEEKABOT_RENDERER_PNG_LOADER_HH


#include "Texture.hh"
#include "AutoRegisteredProvider.hh"


namespace peekabot
{
    namespace renderer
    {

        class PngLoader : public AutoRegisteredProvider<PngLoader, Texture>
        {
        public:
            virtual boost::shared_ptr<Texture> get(const std::string &id);

            virtual bool matches(const std::string &id) throw();

        private:
            static Informer ms_informer;
        };

    }
}


#endif // __PEEKABOT_RENDERER_PNG_LOADER_HH
