/*
 * Copyright Staffan Gimåker 2007-2010.
 *
 * ---
 *
 * This file is part of peekabot.
 *
 * peekabot is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * peekabot is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */


#ifndef PEEKABOT_RENDERER_INDEX_BUFFER_HH_INCLUDED
#define PEEKABOT_RENDERER_INDEX_BUFFER_HH_INCLUDED


#include "ArrayBuffer.hh"


namespace peekabot
{
    namespace renderer
    {
        class IndexBuffer : public ArrayBuffer
        {
        public:
            explicit IndexBuffer(bool force_no_vbos = false);

            IndexBuffer(const IndexBuffer &other);

            void draw_elements(
                GLenum mode, std::size_t count,
                GLenum type, std::size_t off) const;

            void draw_range_elements(
                GLenum mode, std::size_t start, std::size_t end,
                std::size_t count, GLenum type, std::size_t off) const;
        };
    }
}


#endif // PEEKABOT_RENDERER_INDEX_BUFFER_HH_INCLUDED
