/*
 * Copyright Staffan Gimåker 2007-2010.
 *
 * ---
 *
 * This file is part of peekabot.
 *
 * peekabot is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * peekabot is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include "IndexBuffer.hh"
#include "Device.hh"

#include <GL/glew.h>
#include <cassert>
#include <stdexcept>


using namespace peekabot;
using namespace peekabot::renderer;


IndexBuffer::IndexBuffer(bool force_no_vbos)
    : ArrayBuffer(force_no_vbos, true)
{
}


IndexBuffer::IndexBuffer(const IndexBuffer &other)
    : ArrayBuffer(other)
{
}


void IndexBuffer::draw_elements(
    GLenum mode, std::size_t count,
    GLenum type, std::size_t off) const
{
    if( count < 1 )
        return;

    if( is_mapped() )
        throw std::runtime_error(
            "Can't use draw_elements() with a mapped buffer");

    if( uses_vbos() )
    {
        if( !is_bound() )
            bind();

        glDrawElements(mode, count, type, (void *)off);
    }
    else
    {
        clear_index_buffer_vbo_binding();
        glDrawElements(mode, count, type, (void *)(get_data()+off));
    }

    CHECK_GL_ERRORS();
}


void IndexBuffer::draw_range_elements(
    GLenum mode, std::size_t start, std::size_t end,
    std::size_t count, GLenum type, std::size_t off) const
{
    // TODO
    assert(false);
}
