/*
 * Copyright Staffan Gimåker 2007-2008.
 *
 * ---
 *
 * This file is part of peekabot.
 *
 * peekabot is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * peekabot is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef PEEKABOT_RENDERER_FRUSTUM_HH_INCLUDED
#define PEEKABOT_RENDERER_FRUSTUM_HH_INCLUDED


#include "../Types.hh"
#include "BoundingVolumes.hh"


// Workarond for Windows
#ifdef NEAR
#  undef NEAR
#endif
#ifdef FAR
#  undef FAR
#endif
#ifdef near
#  undef near
#endif
#ifdef far
#  undef far
#endif


namespace peekabot
{
    namespace renderer
    {
        class Camera;

        class Frustum
        {
        public:
            /**
             * \brief Named indices for the frustum clip planes.
             */
            enum FrustrumPlane
            {
                LEFT = 0,
                RIGHT = 1,
                TOP = 2,
                BOTTOM = 3,
                NEAR = 4,
                FAR = 5
            };


            Frustum(const Camera &cam, float w_slack = 0, float h_slack = 0);

            inline const Plane &operator[](size_t i) const
            {
                return m_frustum_planes[i];
            }
            
            inline const BoundingSphere &get_bounding_sphere() const throw()
            {
                return m_frustum_bsphere;
            }

            IntersectionTestResult is_in_frustum(
                const BoundingSphere& bsphere, int &plane_mask) const throw();
            
            IntersectionTestResult is_in_frustum(
                const BoundingSphere& bsphere) const throw();
            
            IntersectionTestResult is_in_uncapped_frustum(
                const BoundingSphere& bsphere) const throw();
            
            IntersectionTestResult is_in_uncapped_frustum(
                const BoundingSphere& bsphere, int &plane_mask) const throw();

        private:
            void calculate_frustum_bsphere(
                const Camera &cam, float w_slack, float h_slack) throw();
            
            void calculate_frustum_planes(
                const Camera &cam, float w_slack, float h_slack) throw();

        private:
            /**
             * \brief The view frustum's bounding sphere.
             *
             * The value is defined only when \c m_frustum_bvs_are_valid is true.
             */
            BoundingSphere m_frustum_bsphere;

            Plane m_frustum_planes[6];
        };

    }
}


#endif // PEEKABOT_RENDERER_FRUSTUM_HH_INCLUDED
