/*
 * Copyright Staffan Gimåker 2010.
 *
 * ---
 *
 * This file is part of peekabot.
 *
 * peekabot is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * peekabot is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef PEEKABOT_UINT32_PROP_BASE_HH_INCLUDED
#define PEEKABOT_UINT32_PROP_BASE_HH_INCLUDED


#include "Prop.hh"
#include "PropVisitor.hh"

#include <limits>
#include <boost/cstdint.hpp>


namespace peekabot
{
    class Uint32PropBase : public Prop
    {
    public:
        virtual void accept(PropVisitor &visitor)
        {
            visitor.visit(this);
        }

        virtual boost::uint32_t get_min_value() const
        {
            return 0;
        }

        virtual boost::uint32_t get_max_value() const
        {
            return std::numeric_limits<boost::uint32_t>::max();
        }
    };
}


#endif // PEEKABOT_UINT32_PROP_BASE_HH_INCLUDED
