/*
 * Copyright Staffan Gimåker 2007-2010.
 *
 * ---
 *
 * Distributed under the Boost Software License, Version 1.0.
 * (See accompanying file LICENSE_1_0.txt or copy at
 * http://www.boost.org/LICENSE_1_0.txt)
 */

#ifndef PEEKABOT_PEEKABOT_HH_INCLUDED
#define PEEKABOT_PEEKABOT_HH_INCLUDED


#include <peekabot/client/PeekabotClient.hh>
#include <peekabot/client/Exceptions.hh>
#include <peekabot/Deprecated.hh>
#include <peekabot/Types.hh>

#include <peekabot/client/proxies/ObjectProxy.hh>
#include <peekabot/client/proxies/ScalableProxy.hh>
#include <peekabot/client/proxies/LineBasedProxy.hh>
#include <peekabot/client/proxies/VertexBasedProxy.hh>
#include <peekabot/client/proxies/GroupProxy.hh>
#include <peekabot/client/proxies/SphereProxy.hh>
#include <peekabot/client/proxies/CylinderProxy.hh>
#include <peekabot/client/proxies/CubeProxy.hh>
#include <peekabot/client/proxies/PolygonProxy.hh>
#include <peekabot/client/proxies/CircleProxy.hh>
#include <peekabot/client/proxies/PointCloudProxy.hh>
#include <peekabot/client/proxies/LineCloudProxy.hh>
#include <peekabot/client/proxies/CameraProxy.hh>
#include <peekabot/client/proxies/ModelProxy.hh>
#include <peekabot/client/proxies/OccupancyGrid2DProxy.hh>
#include <peekabot/client/proxies/OccupancyGrid3DProxy.hh>
#include <peekabot/client/proxies/JointProxy.hh>
#include <peekabot/client/proxies/HingeProxy.hh>
#include <peekabot/client/proxies/SliderProxy.hh>
#include <peekabot/client/proxies/GridProxy.hh>
#include <peekabot/client/proxies/LabelProxy.hh>
#include <peekabot/client/proxies/TriMeshProxy.hh>
#include <peekabot/client/proxies/PolylineProxy.hh>


namespace peekabot
{
    // Proxies
    using client::PeekabotClient;
    using client::Status;
    using client::Result;
    using client::ObjectProxy;
    using client::ObjectProxyBase;
    using client::ScalableProxy;
    using client::LineBasedProxy;
    using client::VertexBasedProxy;
    using client::GroupProxy;
    using client::SphereProxy;
    using client::CylinderProxy;
    using client::CubeProxy;
    using client::PolygonProxy;
    using client::CircleProxy;
    using client::PointCloudProxy;
    using client::LineCloudProxy;
    using client::CameraProxy;
    using client::ModelProxy;
    using client::OccupancyGrid2DProxy;
    using client::OccupancyGrid3DProxy;
    using client::JointProxy;
    using client::HingeProxy;
    using client::SliderProxy;
    using client::GridProxy;
    using client::LabelProxy;
    using client::TriMeshProxy;
    using client::PolylineProxy;
    // Exceptions
    using client::AuthenticationFailed;
    using client::HostResolveFailed;
    using client::ConnectionRefused;
    // Misc
    using client::VertexSet;
    using client::ColoredVertexSet;
    using client::OccupancySet2D;
    using client::OccupancySet3D;
    using client::IndexSet;

    // For easier porting from 0.7.x
    typedef Vector3 Vector3f PEEKABOT_DEPRECATED;
}


#endif // PEEKABOT_PEEKABOT_HH_INCLUDED
