/*
 * Copyright Staffan Gimåker 2010-2011.
 *
 * ---
 *
 * This file is part of peekabot.
 *
 * peekabot is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * peekabot is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include "ToolController.hh"
#include "Gui.hh"
#include "NavigateTool.hh"
#include "MoveTool.hh"
#include "RotateTool.hh"

#include <cassert>
#include <boost/bind.hpp>


using namespace peekabot;
using namespace peekabot::gui;


ToolController::ToolController(Gui &gui)
    : m_gui(gui),
      m_nav_tool(new NavigateTool(m_gui)),
      m_move_tool(new MoveTool(m_gui)),
      m_rotate_tool(new RotateTool(m_gui))
{
    m_active_tool = m_nav_tool.get();
    m_active_tool->activate();

    const Glib::RefPtr<Gtk::Builder> &builder = m_gui.get_builder();

    m_nav_tool_action = Glib::RefPtr<Gtk::RadioAction>::cast_dynamic(
        builder->get_object("nav_tool_action"));

    m_move_tool_action = Glib::RefPtr<Gtk::RadioAction>::cast_dynamic(
        builder->get_object("move_tool_action"));

    m_rotate_tool_action = Glib::RefPtr<Gtk::RadioAction>::cast_dynamic(
        builder->get_object("rotate_tool_action"));

    m_nav_tool_action->signal_changed().connect(
        sigc::mem_fun(*this, &ToolController::on_tool_changed));
}


ToolController::~ToolController()
{
}


Tool &ToolController::get_active_tool()
{
    assert( m_active_tool );
    return *m_active_tool;
}


void ToolController::activate_nav_tool()
{
    assert( m_nav_tool );
    if( m_active_tool != m_nav_tool.get() )
    {
        m_nav_tool_action->activate();
    }
}


void ToolController::activate_move_tool()
{
    assert( m_move_tool );
    if( m_active_tool != m_move_tool.get() )
    {
        m_move_tool_action->activate();
    }
}


void ToolController::activate_rotate_tool()
{
    assert( m_rotate_tool );
    if( m_active_tool != m_rotate_tool.get() )
    {
        m_rotate_tool_action->activate();
    }
}


void ToolController::on_tool_changed(
    const Glib::RefPtr<Gtk::RadioAction> &current)
{
    Tool *new_active_tool = 0;

    if( current == m_nav_tool_action )
    {
        if( m_active_tool != m_nav_tool.get() )
        {
            new_active_tool = m_nav_tool.get();
        }
    }
    else if( current == m_move_tool_action )
    {
        if( m_active_tool != m_move_tool.get() )
        {
            new_active_tool = m_move_tool.get();
        }
    }
    else
    {
        assert( current == m_rotate_tool_action );

        if( m_active_tool != m_rotate_tool.get() )
        {
            new_active_tool = m_rotate_tool.get();
        }
    }

    if( new_active_tool )
    {
        m_active_tool->deactivate();
        m_active_tool = new_active_tool;
        m_active_tool->activate();
    }
}
