/*
 * Copyright Staffan Gimåker 2010.
 *
 * ---
 *
 * This file is part of peekabot.
 *
 * peekabot is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * peekabot is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef PEEKABOT_GUI_TOOL_HH_INCLUDED
#define PEEKABOT_GUI_TOOL_HH_INCLUDED


#include <gtkmm.h>


namespace peekabot
{
    namespace gui
    {
        class SceneViewFrame;

        class Tool
        {
        public:
            virtual ~Tool() {}

            virtual void activate() {}

            virtual void deactivate() {}

            virtual void button_release(
                SceneViewFrame *sf, const GdkEventButton *event) {}

            virtual void button_click(
                SceneViewFrame *sf, const GdkEventButton *event) {}

            virtual void mouse_drag(
                SceneViewFrame *sf, const GdkEventMotion *event,
                double dx, double dy) {}

            virtual void scroll(
                SceneViewFrame *sf, const GdkEventScroll *event) {}

            virtual void key_release(
                SceneViewFrame *sf, const GdkEventKey *event) {}
        };
    }
}


#endif // PEEKABOT_GUI_TOOL_HH_INCLUDED
