/*
 * Copyright Staffan Gimåker 2010.
 *
 * ---
 *
 * This file is part of peekabot.
 *
 * peekabot is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * peekabot is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef PEEKABOT_GUI_PREFERENCES_DIALOG_HH_INCLUDED
#define PEEKABOT_GUI_PREFERENCES_DIALOG_HH_INCLUDED


#include <gtkmm.h>
#include <list>
#include <boost/filesystem/path.hpp>


namespace peekabot
{
    class Config;

    namespace gui
    {
        class Gui;

        class PreferencesDialog
        {
        public:
            PreferencesDialog(Gui &gui);

            ~PreferencesDialog();

        private:
            void on_preferences_activated();

            void on_close_clicked();

            void on_dp_add_clicked();

            void on_dp_remove_clicked();

            void on_dp_add_response(int response);

            void on_dp_selection_changed();

            void on_hide();

            void on_show();

        private:
            Gui &m_gui;

            Config &m_config;

            Glib::RefPtr<Gtk::Action> m_preferences_action;

            Gtk::Dialog *m_dialog;

            Gtk::Button *m_close_button;

            Gtk::FileChooserButton *m_screenshot_dir_button;

            typedef std::list<boost::filesystem::path> DataPaths;

            Gtk::TreeView *m_dp_view;

            class DataPathCols;

            DataPathCols *m_dp_cols;

            Glib::RefPtr<Gtk::ListStore> m_dp_model;

            Glib::RefPtr<Gtk::TreeSelection> m_dp_selection;

            Gtk::Button *m_dp_add_button;
            Gtk::Button *m_dp_remove_button;

            Gtk::FileChooserDialog *m_dp_add_dialog;
        };
    }
}


#endif // PEEKABOT_GUI_PREFERENCES_DIALOG_HH_INCLUDED
