/*
 * Copyright Staffan Gimåker 2010.
 *
 * ---
 *
 * This file is part of peekabot.
 *
 * peekabot is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * peekabot is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef PEEKABOT_GUI_NAVIGATE_TOOL_HH_INCLUDED
#define PEEKABOT_GUI_NAVIGATE_TOOL_HH_INCLUDED


#include "../Types.hh"
#include "Tool.hh"


namespace peekabot
{
    class ServerData;

    namespace gui
    {
        class Gui;

        class NavigateTool : public Tool
        {
        public:
            NavigateTool(Gui &gui);

            virtual void button_click(
                SceneViewFrame *sf, const GdkEventButton *event);

            virtual void mouse_drag(
                SceneViewFrame *sf, const GdkEventMotion *event,
                double dx, double dy);

            virtual void scroll(
                SceneViewFrame *sf, const GdkEventScroll *event);

            virtual void key_release(
                SceneViewFrame *sf, const GdkEventKey *event);

        private:
            /// \name Methods executed in the server thread
            /// @{

            void camera_pan(
                ServerData &sd, ObjectID cam_id,
                float dx, float dy, float rate_mod);

            void camera_rotate(
                ServerData &sd, ObjectID cam_id,
                float dx, float dy, float rate_mod);

            void camera_zoom(
                ServerData &sd, ObjectID cam_id,
                float dy, float rate_mod, bool rel);

            /// @}

        private:
            Gui &m_gui;
        };
    }
}


#endif // PEEKABOT_GUI_NAVIGATE_TOOL_HH_INCLUDED
