/*
 * Copyright Staffan Gimåker 2010.
 *
 * ---
 *
 * This file is part of peekabot.
 *
 * peekabot is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * peekabot is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef PEEKABOT_GUI_EXPLORER_CONTROLLER_HH_INCLUDED
#define PEEKABOT_GUI_EXPLORER_CONTROLLER_HH_INCLUDED


#include "../Types.hh"

#include <set>
#include <map>
#include <string>
#include <gtkmm.h>
#include <boost/scoped_ptr.hpp>


namespace peekabot
{
    class ServerData;

    namespace gui
    {
        class Gui;

        class ExplorerController
        {
        public:
            ExplorerController(Gui &gui);

            ~ExplorerController();

        private:
            void object_attached_handler(
                ObjectID id, ObjectID parent,
                std::string name, ObjectType type);

            void object_detached_handler(ObjectID id);

            void object_renamed_handler(ObjectID id, std::string name);

            void selection_changed_handler(ObjectID id, bool selected);

            bool select_handler(
                const Glib::RefPtr<Gtk::TreeModel> &model,
                const Gtk::TreeModel::Path &path, bool);

            void on_view_selection_changed();

            void selected_row_callback(
                const Gtk::TreeModel::iterator &it,
                std::set<ObjectID> &selected);

            void on_rearrange(ObjectID id, ObjectID new_parent_id);

            void ss_rearrange(
                ServerData &sd, ObjectID id, ObjectID new_parent_id);

            bool on_tree_view_enter_notify(GdkEventCrossing *event);

        private:
            /**
             * \brief An ID to TreeStore iterators map.
             *
             * TreeStore iterators are valid as long as the data they refer
             * to exists, so it's safe to keep a map of them even though we
             * erase and add new elements to the store.
             *
             * However note that this map stores TreeStore iterators from
             * m_model, and NOT iterators valid for operations on m_filter (or
             * m_view, by extension).
             *
             * Before using an iterator from this map with m_filter or m_view
             * it must be converted with m_filter->convert_child_iter_to_iter().
             */
            typedef std::map<ObjectID, Gtk::TreeModel::iterator> TreeIters;
            TreeIters m_tree_iters;

            Gui &m_gui;

            Gtk::TreeView *m_view;

            class Cols;

            boost::scoped_ptr<Cols> m_cols;

            class DndTreeStore;

            Glib::RefPtr<DndTreeStore> m_model;

            Glib::RefPtr<Gtk::TreeSelection> m_selection;

            sigc::connection m_view_selection_changed_conn;
        };
    }
}


#endif // PEEKABOT_GUI_EXPLORER_CONTROLLER_HH_INCLUDED
