/*
 * Copyright Staffan Gimåker 2008-2010.
 *
 * ---
 *
 * Distributed under the Boost Software License, Version 1.0.
 * (See accompanying file LICENSE_1_0.txt or copy at
 * http://www.boost.org/LICENSE_1_0.txt)
 */

#include "ScalableProxy.hh"
#include "../PeekabotClient.hh"
#include "../../PropKeys.hh"
#include "../../ObjectTypes.hh"

#include "../../actions/Assign.hh"
#include "../../actions/SetProp.hh"

#include <Eigen/Core>


using namespace peekabot;
using namespace peekabot::client;


//
// ------------------ ScalableProxyBase implementation -------------------
//

ScalableProxyBase::ScalableProxyBase()
{
}


ScalableProxyBase::ScalableProxyBase(const ScalableProxyBase &p)
    : ObjectProxyBase(p)
{
}


DelayedDispatch ScalableProxyBase::set_scale(
    float x_scale, float y_scale, float z_scale)
{
    return DelayedDispatch(
        get_client_impl(),
        new SetProp(get_object_id(), SCALE_PROP,
                    Eigen::Vector3f(x_scale, y_scale, z_scale)));
}


//
// ------------------ ScalableProxy implementation -------------------
//


ScalableProxy::ScalableProxy()
{
}

ScalableProxy::ScalableProxy(const ScalableProxyBase &p)
    : ObjectProxyBase(p),
      ScalableProxyBase(p)
{
}


ScalableProxy &ScalableProxy::operator=(const ScalableProxy &p)
{
    return *this = (ScalableProxyBase &)p;
}


ScalableProxy &ScalableProxy::operator=(const ScalableProxyBase &p)
{
    unchecked_assign(p);
    return *this;
}


DelayedDispatch ScalableProxy::assign(const ObjectProxyBase &p)
{
    unchecked_assign(unchecked_get_client_impl(p), allocate_pseudonym());

    return DelayedDispatch(
        get_client_impl(),
        new Assign(PathIdentifier(get_object_id(p)),
                   get_object_id(), SCALABLE_CLASS));
}


DelayedDispatch ScalableProxy::assign(
    PeekabotClient &client,
    const std::string &path)
{
    unchecked_assign(get_client_impl(client), allocate_pseudonym());

    return DelayedDispatch(
        get_client_impl(),
        new Assign(PathIdentifier(path), get_object_id(), SCALABLE_CLASS));
}


DelayedDispatch ScalableProxy::assign(
    const ObjectProxyBase &parent,
    const std::string &rel_path)
{
    unchecked_assign(get_client_impl(parent), allocate_pseudonym());

    return DelayedDispatch(
        get_client_impl(),
        new Assign(
            PathIdentifier(get_object_id(parent), rel_path),
            get_object_id(), SCALABLE_CLASS));
}
