/*
 * Copyright Staffan Gimåker 2008-2010.
 *
 * ---
 *
 * Distributed under the Boost Software License, Version 1.0.
 * (See accompanying file LICENSE_1_0.txt or copy at
 * http://www.boost.org/LICENSE_1_0.txt)
 */

#include "PolygonProxy.hh"
#include "../PeekabotClient.hh"
#include "../../ObjectTypes.hh"

#include "../../actions/AddObject.hh"
#include "../../actions/Assign.hh"


using namespace peekabot;
using namespace peekabot::client;


//
// ------------------ PolygonProxyBase implementation -------------------
//


PolygonProxyBase::PolygonProxyBase()
{
}


PolygonProxyBase::PolygonProxyBase(const PolygonProxyBase &p)
    : ObjectProxyBase(p),
      ScalableProxyBase(p),
      VertexBasedProxyBase(p)
{
}


//
// ------------------ PolygonProxy implementation -------------------
//


PolygonProxy::PolygonProxy()
{
}


PolygonProxy::PolygonProxy(const PolygonProxyBase &p)
    : ObjectProxyBase(p),
      PolygonProxyBase(p)
{
}


PolygonProxy &PolygonProxy::operator=(const PolygonProxy &p)
{
    return *this = (PolygonProxyBase &)p;
}


PolygonProxy &PolygonProxy::operator=(const PolygonProxyBase &p)
{
    unchecked_assign(unchecked_get_client_impl(p), get_pseudonym(p));
    return *this;
}


DelayedDispatch PolygonProxy::assign(const ObjectProxyBase &p)
{
    unchecked_assign(get_client_impl(p), allocate_pseudonym());

    return DelayedDispatch(
        get_client_impl(),
        new Assign(PathIdentifier(get_object_id(p)),
                   get_object_id(), POLYGON_OBJECT));
}


DelayedDispatch PolygonProxy::assign(
    PeekabotClient &client,
    const std::string &path)
{
    unchecked_assign(get_client_impl(client), allocate_pseudonym());

    return DelayedDispatch(
        get_client_impl(),
        new Assign(PathIdentifier(path), get_object_id(), POLYGON_OBJECT));
}


DelayedDispatch PolygonProxy::assign(
    const ObjectProxyBase &parent, 
    const std::string &rel_path)
{
    unchecked_assign(get_client_impl(parent), allocate_pseudonym());

    return DelayedDispatch(
        get_client_impl(), new Assign(
            PathIdentifier(get_object_id(parent), rel_path),
            get_object_id(), POLYGON_OBJECT));
}


DelayedDispatch PolygonProxy::add(
    PeekabotClient &client,
    const std::string &path,
    NameConflictPolicy conflict_policy)
{
    unchecked_assign(get_client_impl(client), allocate_pseudonym());

    return DelayedDispatch(
        get_client_impl(),
        new AddObject(PathIdentifier(path), conflict_policy,
                      get_object_id(), POLYGON_OBJECT));
}


DelayedDispatch PolygonProxy::add(
    const ObjectProxyBase &parent, 
    const std::string &name,
    NameConflictPolicy conflict_policy)
{
    unchecked_assign(get_client_impl(parent), allocate_pseudonym());

    return DelayedDispatch(
        get_client_impl(),
        new AddObject(PathIdentifier(get_object_id(parent), name),
                      conflict_policy, get_object_id(), POLYGON_OBJECT));
}
