/*
 * Copyright Staffan Gimåker 2008-2010.
 *
 * ---
 *
 * Distributed under the Boost Software License, Version 1.0.
 * (See accompanying file LICENSE_1_0.txt or copy at
 * http://www.boost.org/LICENSE_1_0.txt)
 */

#ifndef PEEKABOT_CLIENT_POINT_CLOUD_PROXY_HH_INCLUDED
#define PEEKABOT_CLIENT_POINT_CLOUD_PROXY_HH_INCLUDED


#include "ScalableProxy.hh"
#include "VertexBasedProxy.hh"


namespace peekabot
{
    namespace client
    {
        /**
         * \brief Base class for PointCloudProxy.
         */
        class PEEKABOT_API PointCloudProxyBase : public ScalableProxyBase,
                                                 public VertexBasedProxyBase
        {
        public:
            PointCloudProxyBase();

            PointCloudProxyBase(const PointCloudProxyBase &p);
        };


        /**
         * \brief Proxy class used to add and manipulate point clouds.
         *
         * The points in the point cloud are manipulated through the methods 
         * exposed by VertexBasedProxyBase, e.g. set_vertices(), add_vertices()
         * and clear_vertices().
         */
        class PEEKABOT_API PointCloudProxy : public PointCloudProxyBase
        {
        public:
            PointCloudProxy();

            PointCloudProxy(const PointCloudProxyBase &p);

            PointCloudProxy &operator=(const PointCloudProxy &p);

            PointCloudProxy &operator=(const PointCloudProxyBase &p);

            /**
             * \copydoc ScalableProxy::assign(const ObjectProxyBase&)
             */
            DelayedDispatch assign(const ObjectProxyBase &p);

            /**
             * \copydoc ObjectProxy::assign(PeekabotClient&,const std::string&)
             */
            DelayedDispatch assign(
                PeekabotClient &client,
                const std::string &path);

            /**
             * \copydoc 
             * ObjectProxy::assign(const ObjectProxyBase&,const std::string&)
             */
            DelayedDispatch assign(
                const ObjectProxyBase &parent, 
                const std::string &rel_path);

            /**
             * \brief Add a point cloud to the scene.
             *
             * Adds an empty point cloud to the scene at the given path and 
             * assigns the proxy to point to it. If an object already exists at
             * the given path the outcome is governed by \a conflict_policy.
             *
             * \param path The path where the object will be added, including 
             * the name of the object.
             * \param conflict_policy Determines how name conflicts are handled.
             */
            DelayedDispatch add(
                PeekabotClient &client,
                const std::string &path,
                NameConflictPolicy conflict_policy = AUTO_ENUMERATE_ON_CONFLICT);

            /**
             * \brief Add a point cloud to the scene.
             *
             * Adds an empty point cloud with the given name under the 
             * object referred to by \a parent and assigns the proxy to point 
             * to it. If an object already exists at the given path the outcome
             * is governed by \a conflict_policy.
             *
             * \param parent The parent under which the object will be added.
             * \param name The name to assign to the created object.
             * \param conflict_policy Determines how name conflicts are handled.
             */
            DelayedDispatch add(
                const ObjectProxyBase &parent, 
                const std::string &name,
                NameConflictPolicy conflict_policy = AUTO_ENUMERATE_ON_CONFLICT);
        };
    }
}


#endif // PEEKABOT_CLIENT_POINT_CLOUD_PROXY_HH_INCLUDED
