/*
 * Copyright Staffan Gimåker 2008-2010.
 *
 * ---
 *
 * Distributed under the Boost Software License, Version 1.0.
 * (See accompanying file LICENSE_1_0.txt or copy at
 * http://www.boost.org/LICENSE_1_0.txt)
 */

#include "PeekabotProxyBase.hh"
#include "../PeekabotClient.hh"
#include "../ClientImpl.hh"


using namespace peekabot;
using namespace peekabot::client;


PeekabotProxyBase::~PeekabotProxyBase()
{
}


PeekabotProxyBase::PeekabotProxyBase(const PeekabotProxyBase &p)
    : m_client_impl(p.unchecked_get_client_impl())
{
}


PeekabotProxyBase::PeekabotProxyBase()
{
}


void PeekabotProxyBase::set_client_impl(
    boost::shared_ptr<ClientImpl> client)
{
    boost::recursive_mutex::scoped_lock lock(m_mutex);
    m_client_impl = client;
}


boost::shared_ptr<ClientImpl>
PeekabotProxyBase::unchecked_get_client_impl() const
{
    boost::recursive_mutex::scoped_lock lock(m_mutex);
    return m_client_impl;
}


boost::shared_ptr<ClientImpl> PeekabotProxyBase::unchecked_get_client_impl(
    const PeekabotProxyBase &p)
{
    return p.unchecked_get_client_impl();
}


boost::shared_ptr<ClientImpl> PeekabotProxyBase::get_client_impl() const
{
    boost::recursive_mutex::scoped_lock lock(m_mutex);
    if( !m_client_impl )
        throw std::logic_error("Proxy not assigned");
    return m_client_impl;
}


boost::shared_ptr<ClientImpl> PeekabotProxyBase::get_client_impl(
    const PeekabotProxyBase &p)
{
    return p.get_client_impl();
}


boost::shared_ptr<ClientImpl> PeekabotProxyBase::get_client_impl(
    PeekabotClient &client)
{
    return client.get_impl();
}


void PeekabotProxyBase::dispatch_action(Action *action, Status *status) const
{
    boost::recursive_mutex::scoped_lock lock(m_mutex);
    get_client_impl()->dispatch_action(action, status, false, false);
}


boost::shared_ptr<OperationResult> PeekabotProxyBase::dispatch_get_action(
    Action *action, uint32_t request_id) const
{
    boost::recursive_mutex::scoped_lock lock(m_mutex);
    return get_client_impl()->dispatch_get_action(action, request_id, false);
}

uint32_t PeekabotProxyBase::allocate_request_id() const
{
    return get_client_impl()->allocate_request_id();
}


PeekabotClient PeekabotProxyBase::get_client() const
{
    return PeekabotClient(get_client_impl());
}


bool PeekabotProxyBase::is_assigned() const
{
    boost::recursive_mutex::scoped_lock lock(m_mutex);
    return m_client_impl;
}
