/*
 * Copyright Staffan Gimåker 2008-2009.
 *
 * ---
 *
 * Distributed under the Boost Software License, Version 1.0.
 * (See accompanying file LICENSE_1_0.txt or copy at
 * http://www.boost.org/LICENSE_1_0.txt)
 */

#ifndef PEEKABOT_CLIENT_LINE_BASED_PROXY_HH_INCLUDED
#define PEEKABOT_CLIENT_LINE_BASED_PROXY_HH_INCLUDED


#include <string>

#include "ObjectProxy.hh"
#include "../DelayedDispatch.hh"


namespace peekabot
{
    namespace client
    {
        /**
         * \brief Base class for all proxies to line-based objects.
         */
        class PEEKABOT_API LineBasedProxyBase : virtual public ObjectProxyBase
        {
        public:
            LineBasedProxyBase();

            LineBasedProxyBase(const LineBasedProxyBase &p);

            /**
             * \brief Set the object's line width.
             *
             * \pre width > 0
             */
            DelayedDispatch set_line_width(float width);

            /**
             * \brief Set the object's line style.
             *
             * \pre factor > 0
             *
             * \param factor The rate at which the pattern given by \a 
             * style repeats itself. Large factor implies a coarser pattern.
             */
            DelayedDispatch set_line_style(LineStyle style, int factor = 1);

            /**
             * \brief Set the object's line style.
             *
             * \pre factor > 0
             *
             * \param style Must be "solid", "dashed", "dotted", "dash-dot" or
             * "dash-dot-dot".
             * \param factor The rate at which the pattern given by \a 
             * style repeats itself. Large factor implies a coarser pattern.
             *
             * \throw std::runtime_error Thrown if style does not have of the
             * values listed above.
             */
            DelayedDispatch set_line_style(const std::string &style, int factor = 1);
        };

        /**
         * \brief Proxy class usable with any type of object that is line-based.
         */
        class PEEKABOT_API LineBasedProxy : public LineBasedProxyBase
        {
        public:
            LineBasedProxy();

            LineBasedProxy(const LineBasedProxyBase &p);

            LineBasedProxy &operator=(const LineBasedProxy &p);

            LineBasedProxy &operator=(const LineBasedProxyBase &p);

            /**
             * \copydoc ScalableProxy::assign(const ObjectProxyBase&)
             */
            DelayedDispatch assign(const ObjectProxyBase &p);

            /**
             * \copydoc ObjectProxy::assign(PeekabotClient&,const std::string&)
             */
            DelayedDispatch assign(
                PeekabotClient &client,
                const std::string &path);

            /**
             * \copydoc
             * ObjectProxy::assign(const ObjectProxyBase&,const std::string&)
             */
            DelayedDispatch assign(
                const ObjectProxyBase &parent, 
                const std::string &rel_path);
        };
    }
}


#endif // PEEKABOT_CLIENT_LINE_BASED_PROXY_HH_INCLUDED
