/*
 * Copyright Staffan Gimåker 2008-2010.
 *
 * ---
 *
 * Distributed under the Boost Software License, Version 1.0.
 * (See accompanying file LICENSE_1_0.txt or copy at
 * http://www.boost.org/LICENSE_1_0.txt)
 */

#include "JointProxy.hh"
#include "../PeekabotClient.hh"
#include "../../PropKeys.hh"
#include "../../ObjectTypes.hh"

#include "../../actions/Assign.hh"
#include "../../actions/SetProp.hh"


using namespace peekabot;
using namespace peekabot::client;


//
// ------------------ JointProxyBase implementation -------------------
//


JointProxyBase::JointProxyBase()
{
}


JointProxyBase::JointProxyBase(const JointProxyBase &p)
    : ObjectProxyBase(p)
{
}


DelayedDispatch JointProxyBase::set_dof(float val)
{
    return DelayedDispatch(
        get_client_impl(),
        new SetProp(get_object_id(), JOINT_VALUE_PROP, val));
}


DelayedDispatch JointProxyBase::set_min(float min)
{
    return DelayedDispatch(
        get_client_impl(),
        new SetProp(get_object_id(), JOINT_MIN_PROP, min));
}


DelayedDispatch JointProxyBase::set_max(float max)
{
    return DelayedDispatch(
        get_client_impl(),
        new SetProp(get_object_id(), JOINT_MAX_PROP, max));
}


DelayedDispatch JointProxyBase::set_offset(float offset)
{
    return DelayedDispatch(
        get_client_impl(),
        new SetProp(get_object_id(), JOINT_OFFSET_PROP, offset));
}


//
// ------------------ JointProxy implementation -------------------
//


JointProxy::JointProxy()
{
}


JointProxy::JointProxy(const JointProxyBase &p)
    : JointProxyBase(p)
{
}


JointProxy &JointProxy::operator=(const JointProxy &p)
{
    return *this = (JointProxyBase &)p;
}


JointProxy &JointProxy::operator=(const JointProxyBase &p)
{
    unchecked_assign(unchecked_get_client_impl(p), get_pseudonym(p));

    return *this;
}


DelayedDispatch JointProxy::assign(const ObjectProxyBase &p)
{
    unchecked_assign(get_client_impl(p), allocate_pseudonym());

    return DelayedDispatch(
        get_client_impl(),
        new Assign(PathIdentifier(get_object_id(p)),
                   get_object_id(), JOINT_CLASS));
}


DelayedDispatch JointProxy::assign(
    PeekabotClient &client, const std::string &path)
{
    unchecked_assign(get_client_impl(client), allocate_pseudonym());

    return DelayedDispatch(
        get_client_impl(),
        new Assign(PathIdentifier(path), get_object_id(), JOINT_CLASS));
}


DelayedDispatch JointProxy::assign(
    const ObjectProxyBase &parent,
    const std::string &rel_path)
{
    unchecked_assign(get_client_impl(parent), allocate_pseudonym());

    return DelayedDispatch(
        get_client_impl(),
        new Assign(
            PathIdentifier(get_object_id(parent), rel_path),
            get_object_id(), JOINT_CLASS));
}
