/*
 * Copyright Staffan Gimåker 2009
 *
 * ---
 *
 * Distributed under the Boost Software License, Version 1.0.
 * (See accompanying file LICENSE_1_0.txt or copy at
 * http://www.boost.org/LICENSE_1_0.txt)
 */

#include <stdexcept>
#include <boost/bind.hpp>

#include "RecordingImpl.hh"
#include "ClientImpl.hh"
#include "../PbarPlayer.hh"


using namespace peekabot;
using namespace peekabot::client;


RecordingImpl::RecordingImpl(
    ClientImpl &client,
    const std::string &filename)
    : m_client(client),
      m_player(filename, boost::bind(&RecordingImpl::dispatch, this, _1))
{
    if( m_player.is_multi_client_recording() )
        throw std::runtime_error(
            "Only single-client recordings can be played from the client, "
            "please use the server's GUI interface to replay multi-client "
            "recordings");
}


void RecordingImpl::play()
{
    m_player.play();
}


void RecordingImpl::pause()
{
    m_player.pause();
}


bool RecordingImpl::is_paused() const
{
    return m_player.is_paused();
}


bool RecordingImpl::is_finished() const
{
    return m_player.is_finished();
}


void RecordingImpl::step(size_t n)
{
    m_player.step(n);
}


void RecordingImpl::step(const boost::posix_time::time_duration &td)
{
    m_player.step(td);
}


void RecordingImpl::set_playback_speed(double factor)
{
    m_player.set_playback_speed(factor);
}


double RecordingImpl::get_playback_speed() const
{
    return m_player.get_playback_speed();
}


boost::posix_time::time_duration RecordingImpl::elapsed() const
{
    return m_player.elapsed();
}


boost::posix_time::time_duration RecordingImpl::duration() const
{
    return m_player.duration();
}


void RecordingImpl::dispatch(boost::shared_ptr<Action> action)
{
    m_client.dispatch_action(action, 0, true, false);
}
