/*
 * Copyright Staffan Gimåker 2008-2010.
 *
 * ---
 *
 * Distributed under the Boost Software License, Version 1.0.
 * (See accompanying file LICENSE_1_0.txt or copy at
 * http://www.boost.org/LICENSE_1_0.txt)
 */

#include "DelayedDispatch.hh"
#include "ClientImpl.hh"
#include "Status.hh"
#include "../Action.hh"


using namespace peekabot;
using namespace peekabot::client;


DelayedDispatch::DelayedDispatch(
    boost::shared_ptr<ClientImpl> client,
    boost::shared_ptr<Action> action,
    bool master_only)
    : m_client(client),
      m_action(action),
      m_master_only(master_only)
{
}


DelayedDispatch::DelayedDispatch(
    boost::shared_ptr<ClientImpl> client,
    Action *action,
    bool master_only)
    : m_client(client),
      m_action(action),
      m_master_only(master_only)
{
}


DelayedDispatch::~DelayedDispatch()
{
    if( m_action )
    {
        m_client->dispatch_action(m_action, 0, false, m_master_only);
        m_action.reset();
    }
}


Status DelayedDispatch::status()
{
    Status s;
    m_client->dispatch_action(m_action, &s, false, m_master_only);
    m_action.reset();
    return s;
}
