/*
 * Copyright Staffan Gimåker 2006-2009.
 *
 * ---
 *
 * Distributed under the Boost Software License, Version 1.0.
 * (See accompanying file LICENSE_1_0.txt or copy at
 * http://www.boost.org/LICENSE_1_0.txt)
 */

#include "ClientImpl.hh"
#include "ClientExecutionContext.hh"


using namespace peekabot;
using namespace peekabot::client;



ClientExecutionContext::ClientExecutionContext(ClientImpl *client) throw()
    : m_client(client)
{
}


void ClientExecutionContext::report_action_status(
    boost::uint32_t request_id,
    OperationOutcome outcome,
    const std::string &error_msg) throw()
{
    m_client->report_action_status(request_id, outcome, error_msg);
}


void ClientExecutionContext::report_action_result(
    boost::uint32_t request_id,
    const Any &result) throw()
{
    m_client->report_action_result(request_id, result);
}
