/*
 * Copyright Staffan Gimåker 2009.
 *
 * ---
 *
 * Distributed under the Boost Software License, Version 1.0.
 * (See accompanying file LICENSE_1_0.txt or copy at
 * http://www.boost.org/LICENSE_1_0.txt)
 */

#ifndef PEEKABOT_UPLOAD_FILE_HH_INCLUDED
#define PEEKABOT_UPLOAD_FILE_HH_INCLUDED


#include <boost/scoped_array.hpp>
#include <boost/cstdint.hpp>

#include "../Types.hh"
#include "../Action.hh"


namespace peekabot
{
    class UploadFile : public Action
    {
        PEEKABOT_SERIALIZABLE

    public:
        UploadFile(const std::string &path);

        virtual ~UploadFile() throw();

        virtual Action *clone() const;

        virtual void execute(ServerExecutionContext *context) const;

    private:
        UploadFile();

        UploadFile(const UploadFile &other);

    protected:
        void save(SerializationInterface &ar) const;

        void load(DeserializationInterface &ar);

    private:
        std::string m_path;

        boost::uint64_t m_file_len;

        boost::scoped_array<boost::uint8_t> m_file_data;
    };
}


// PEEKABOT_REGISTER_SERIALIZABLE 100


#endif // PEEKABOT_UPLOAD_FILE_HH_INCLUDED
