/*
 * Copyright Staffan Gimåker 2006-2009.
 *
 * ---
 *
 * Distributed under the Boost Software License, Version 1.0.
 * (See accompanying file LICENSE_1_0.txt or copy at
 * http://www.boost.org/LICENSE_1_0.txt)
 */

#ifndef PEEKABOT_SET_TRANSFORMATION_HH_INCLUDED
#define PEEKABOT_SET_TRANSFORMATION_HH_INCLUDED


#include "../Types.hh"
#include "../Action.hh"

#include <Eigen/Geometry>


namespace peekabot
{
    /**
     * \brief Set the model to parent transformation of an object, i.e. set its
     * coordinate system.
     */
    class SetTransformation : public Action
    {
        PEEKABOT_SERIALIZABLE

    public:
        SetTransformation(
            ObjectID target,
            const Eigen::Transform3f &m,
            CoordinateSystem coord_sys) throw();

        virtual Action *clone() const;

        virtual void execute(
            ServerExecutionContext *context)
            const throw(std::exception);

    private:
        SetTransformation() throw();

    protected:
        void save(SerializationInterface &ar) const;

        void load(DeserializationInterface &ar);

    private:
        ObjectID m_target;
        Eigen::Transform3f m_transformation;
        CoordinateSystem m_coord_sys;
    };
}


// PEEKABOT_REGISTER_SERIALIZABLE 1


#endif // PEEKABOT_SET_TRANSFORMATION_HH_INCLUDED
