/*
 * Copyright Staffan Gimåker 2007-2009.
 *
 * ---
 *
 * Distributed under the Boost Software License, Version 1.0.
 * (See accompanying file LICENSE_1_0.txt or copy at
 * http://www.boost.org/LICENSE_1_0.txt)
 */

#ifndef PEEKABOT_SET_POSE_HH_INCLUDED
#define PEEKABOT_SET_POSE_HH_INCLUDED


#include "../Types.hh"
#include "../Action.hh"

#include <stdexcept>


namespace peekabot
{
    /**
     * \brief An action that merges the procedure for setting an object's
     * position and orientation into one easy to use package.
     */
    class SetPose : public Action
    {
        PEEKABOT_SERIALIZABLE

    public:
        SetPose(
            ObjectID target,
            float x, float y, float z,
            float yaw, float roll, float pitch,
            CoordinateSystem coord_sys) throw();

        virtual ~SetPose() throw();

        virtual Action *clone() const;

        virtual void execute(
            ServerExecutionContext *context)
            const throw(std::exception);

    private:
        SetPose() throw();

        SetPose(const SetPose &action) throw();

    protected:
        void save(SerializationInterface &ar) const;

        void load(DeserializationInterface &ar);

    private:
        ObjectID m_target;

        float m_x, m_y, m_z;

        float m_yaw, m_roll, m_pitch;

        CoordinateSystem m_coord_sys;
    };
}


// PEEKABOT_REGISTER_SERIALIZABLE 34


#endif // PEEKABOT_SET_POSE_HH_INCLUDED
