/*
 * Copyright Staffan Gimåker 2007-2009.
 *
 * ---
 *
 * Distributed under the Boost Software License, Version 1.0.
 * (See accompanying file LICENSE_1_0.txt or copy at
 * http://www.boost.org/LICENSE_1_0.txt)
 */

#ifndef PEEKABOT_SET_ORIENTATION_HH_INCLUDED
#define PEEKABOT_SET_ORIENTATION_HH_INCLUDED


#include "../Types.hh"
#include "../Action.hh"

#include <stdexcept>
#include <Eigen/Core>


namespace peekabot
{
    /**
     * \brief Set the orientation of an object. 
     *
     * The orientation direction is defined as the direction of an object's 
     * positive X-axis, e.g. this action will adjust the object's transformation
     * so that it's X-axis points in the desired direction. The object's 
     * coordinate system will only be rotated in the plane formed by the old and
     * the desired orientation.
     */
    class SetOrientation : public Action
    {
        PEEKABOT_SERIALIZABLE

    public:
        SetOrientation(
            ObjectID target,
            const Eigen::Vector3f &orientation,
            CoordinateSystem coord_sys) throw(std::logic_error);

        virtual ~SetOrientation() throw();

        virtual Action *clone() const;

        virtual void execute(
            ServerExecutionContext *context) 
            const throw(std::exception);

    private:
        SetOrientation() throw();

        SetOrientation(const SetOrientation &action) throw();

    protected:
        void save(SerializationInterface &ar) const;

        void load(DeserializationInterface &ar);

    private:
        ObjectID m_target;

        /**
         * \brief The orientation vector to be set. Must always be normalized.
         */
        Eigen::Vector3f m_orientation;

        CoordinateSystem m_coord_sys;
    };
}


// PEEKABOT_REGISTER_SERIALIZABLE 36


#endif // PEEKABOT_SET_ORIENTATION_HH_INCLUDED
