/*
 * Copyright Staffan Gimåker 2008-2009.
 *
 * ---
 *
 * Distributed under the Boost Software License, Version 1.0.
 * (See accompanying file LICENSE_1_0.txt or copy at
 * http://www.boost.org/LICENSE_1_0.txt)
 */

#ifndef PEEKABOT_SET_OCCUPANCY_GRID_2D_CELLS_HH_INCLUDED
#define PEEKABOT_SET_OCCUPANCY_GRID_2D_CELLS_HH_INCLUDED


#include <vector>
#include <utility>
#include <Eigen/Core>

#include "../Types.hh"
#include "../Action.hh"


namespace peekabot
{
    /**
     * \brief This action is used to set the coordinates of a  object.
     *
     * \sa \c Object
     */
    class SetOccupancyGrid2DCells : public Action
    {
        PEEKABOT_SERIALIZABLE

    public:
        SetOccupancyGrid2DCells(
            ObjectID target,
            const std::vector<std::pair<Eigen::Vector2f, float> > &cells)
            throw();

        virtual ~SetOccupancyGrid2DCells() throw();

        virtual Action *clone() const;

        virtual void execute(ServerExecutionContext *context) const;

    private:
        SetOccupancyGrid2DCells() throw();

        SetOccupancyGrid2DCells(const SetOccupancyGrid2DCells &x) throw();

    protected:
        void save(SerializationInterface &ar) const;

        void load(DeserializationInterface &ar);

    private:
        ObjectID m_target;

        std::vector<std::pair<Eigen::Vector2f, float> > m_cells;
    };
}


// PEEKABOT_REGISTER_SERIALIZABLE 57


#endif // PEEKABOT_SET_OCCUPANCY_GRID_2D_CELLS_HH_INCLUDED
