/*
 * Copyright Staffan Gimåker 2006-2009.
 *
 * ---
 *
 * Distributed under the Boost Software License, Version 1.0.
 * (See accompanying file LICENSE_1_0.txt or copy at
 * http://www.boost.org/LICENSE_1_0.txt)
 */

#ifndef PEEKABOT_REMOVE_OBJECT_HH_INCLUDED
#define PEEKABOT_REMOVE_OBJECT_HH_INCLUDED


#include <exception>
#include "../Types.hh"
#include "../Action.hh"


namespace peekabot
{
    class RemoveObject : public Action
    {
        PEEKABOT_SERIALIZABLE

    public:
        RemoveObject(ObjectID id) throw();

        virtual ~RemoveObject() throw();

        virtual Action *clone() const;

        virtual void execute(
            ServerExecutionContext *context) 
            const throw(std::exception);

    private:
        RemoveObject() throw();

    protected:
        void save(SerializationInterface &ar) const;

        void load(DeserializationInterface &ar);

    private:
        ObjectID m_id;
    };
}


// PEEKABOT_REGISTER_SERIALIZABLE 20


#endif // PEEKABOT_REMOVE_OBJECT_HH_INCLUDED"
