/*
 * Copyright Staffan Gimåker 2009.
 *
 * ---
 *
 * Distributed under the Boost Software License, Version 1.0.
 * (See accompanying file LICENSE_1_0.txt or copy at
 * http://www.boost.org/LICENSE_1_0.txt)
 */

#ifndef PEEKABOT_REMOVE_FILE_HH_INCLUDED
#define PEEKABOT_REMOVE_FILE_HH_INCLUDED


#include "../Action.hh"


namespace peekabot
{
    class RemoveFile : public Action
    {
        PEEKABOT_SERIALIZABLE

    public:
        RemoveFile(const std::string &path);

        virtual ~RemoveFile() throw();

        virtual Action *clone() const;

        virtual void execute(ServerExecutionContext *context) const;

    private:
        RemoveFile();

        RemoveFile(const RemoveFile &other);

    protected:
        void save(SerializationInterface &ar) const;

        void load(DeserializationInterface &ar);

    private:
        std::string m_path;
    };
}


// PEEKABOT_REGISTER_SERIALIZABLE 102


#endif // PEEKABOT_REMOVE_FILE_HH_INCLUDED
