/*
 * Copyright Staffan Gimåker 2009-2010.
 *
 * ---
 *
 * Distributed under the Boost Software License, Version 1.0.
 * (See accompanying file LICENSE_1_0.txt or copy at
 * http://www.boost.org/LICENSE_1_0.txt)
 */

#include "RemoveFile.hh"

#ifdef __PEEKABOT_SERVER
#  include "../ServerExecutionContext.hh"
#endif


using namespace peekabot;


RemoveFile::RemoveFile(const std::string &path)
    : m_path(path)
{
}


RemoveFile::RemoveFile()
{
}


RemoveFile::RemoveFile(const RemoveFile &other)
    : m_path(other.m_path)
{
}


RemoveFile::~RemoveFile() throw()
{
}


Action *RemoveFile::clone() const
{
    return new RemoveFile(*this);
}


void RemoveFile::execute(ServerExecutionContext *context) const
{
#ifdef __PEEKABOT_SERVER
    context->remove_remote_file(m_path);
#endif
}


void RemoveFile::save(SerializationInterface &ar) const
{
    ar << m_path;
}


void RemoveFile::load(DeserializationInterface &ar)
{
    ar >> m_path;
}
