/*
 * Copyright Anders Boberg 2006.
 * Copyright Staffan Gimåker 2006-2009.
 *
 * ---
 *
 * Distributed under the Boost Software License, Version 1.0.
 * (See accompanying file LICENSE_1_0.txt or copy at
 * http://www.boost.org/LICENSE_1_0.txt)
 */

#ifndef PEEKABOT_REARRANGE_OBJECT_HH_INCLUDED
#define PEEKABOT_REARRANGE_OBJECT_HH_INCLUDED


#include <exception>
#include "../Types.hh"
#include "../Action.hh"
#include "../PathIdentifier.hh"


namespace peekabot
{
    class RearrangeObject : public Action
    {
        PEEKABOT_SERIALIZABLE

    public:
        RearrangeObject(
            PathIdentifier object, 
            PathIdentifier new_parent,
            bool retain_world_pose = true,
            NameConflictPolicy conflict_policy = FAIL_ON_CONFLICT) throw();

        virtual ~RearrangeObject() throw();

        virtual Action *clone() const;

        virtual void execute(
            ServerExecutionContext *context) 
            const throw(std::exception);

    private:
        RearrangeObject() throw();

    protected:
        void save(SerializationInterface &ar) const;

        void load(DeserializationInterface &ar);

    private:
        PathIdentifier m_object_id;

        PathIdentifier m_new_parent_id;

        bool m_retain_world_pose;

        NameConflictPolicy m_conflict_policy;
    };
}


// PEEKABOT_REGISTER_SERIALIZABLE 21


#endif // PEEKABOT_REARRANGE_OBJECT_HH_INCLUDED
