/*
 * Copyright Staffan Gimåker 2008-2009.
 *
 * ---
 *
 * Distributed under the Boost Software License, Version 1.0.
 * (See accompanying file LICENSE_1_0.txt or copy at
 * http://www.boost.org/LICENSE_1_0.txt)
 */

#ifndef PEEKABOT_MONITOR_REPORT_HH_INCLUDED
#define PEEKABOT_MONITOR_REPORT_HH_INCLUDED


#include <string>
#include <exception>
#include "../Types.hh"
#include "../Action.hh"
#include "../client/Status.hh"


namespace peekabot
{
    /**
     * \brief Contains the outcome of an action executed in the server, which
     * is then reported to back to the source proxy.
     *
     * Each \c MonitorReport is generated by a \c ActionMonitor corresponding 
     * to the monitored action.
     *
     * \c ActionMonitor, \c OperationStatus, \c Status, \c ClientImpl
     */
    class MonitorReport : public Action
    {
        PEEKABOT_SERIALIZABLE

    public:
        MonitorReport(
            uint32_t request_id,
            client::OperationOutcome outcome,
            const std::string &error_msg = "") throw();

        virtual ~MonitorReport() throw();

        virtual Action *clone() const;

        virtual void execute(
            ClientExecutionContext *context) 
            const throw(std::exception);

    private:
        MonitorReport() throw();

    protected:
        void save(SerializationInterface &ar) const;

        void load(DeserializationInterface &ar);

    private:
        uint32_t m_request_id;
        client::OperationOutcome m_outcome;
        std::string m_error_msg;
    };
}


// PEEKABOT_REGISTER_SERIALIZABLE 29


#endif // PEEKABOT_MONITOR_REPORT_HH_INCLUDED
