/*
 * Copyright Staffan Gimåker 2006-2009.
 *
 * ---
 *
 * Distributed under the Boost Software License, Version 1.0.
 * (See accompanying file LICENSE_1_0.txt or copy at
 * http://www.boost.org/LICENSE_1_0.txt)
 */

#include "MonitorReport.hh"
#include "../client/ClientExecutionContext.hh"


using namespace peekabot;


MonitorReport::MonitorReport() throw()
{
}


MonitorReport::MonitorReport(
    uint32_t request_id,
    client::OperationOutcome outcome,
    const std::string &error_msg) throw()
    : m_request_id(request_id),
      m_outcome(outcome),
      m_error_msg(error_msg)
{
}


MonitorReport::~MonitorReport() throw()
{
}


Action *MonitorReport::clone() const
{
    return new MonitorReport(m_request_id, m_outcome, m_error_msg);
}


void MonitorReport::execute(
    ClientExecutionContext *context) 
    const throw(std::exception)
{
#ifdef __PEEKABOT_CLIENT
    context->report_action_status(m_request_id, m_outcome, m_error_msg);
#endif
}


void MonitorReport::save(SerializationInterface &ar) const
{
    uint32_t _outcome = (uint32_t)m_outcome;
    ar << m_request_id << _outcome << m_error_msg;
}

void MonitorReport::load(DeserializationInterface &ar)
{
    uint32_t _outcome;
    ar >> m_request_id >> _outcome >> m_error_msg;
    m_outcome = (client::OperationOutcome)_outcome;
}
