/*
 * Copyright Staffan Gimåker 2006-2010.
 *
 * ---
 *
 * Distributed under the Boost Software License, Version 1.0.
 * (See accompanying file LICENSE_1_0.txt or copy at
 * http://www.boost.org/LICENSE_1_0.txt)
 */

#include <cassert>
#include <stdexcept>
#include <boost/format.hpp>

#include "MiniBundle.hh"
#include "../serialization/Containers.hh"
#include "../serialization/SmartPtrs.hh"

#ifdef __PEEKABOT_SERVER
#  include "../ServerExecutionContext.hh"
#else
#  include "../client/ClientExecutionContext.hh"
#endif


using namespace peekabot;


MiniBundle::MiniBundle()
{
}


MiniBundle::MiniBundle(const MiniBundle &bundle)
{
    for( std::vector<boost::shared_ptr<Action> >::const_iterator it =
             bundle.m_actions.begin();
         it != bundle.m_actions.end(); ++it )
    {
        add_action(boost::shared_ptr<Action>((*it)->clone()));
    }
}


Action *MiniBundle::clone() const
{
    return new MiniBundle(*this);
}


void MiniBundle::execute(ServerExecutionContext *context) const
{
#ifdef __PEEKABOT_SERVER
    for( std::size_t i = 0; i < m_actions.size(); ++i )
    {
        m_actions[i]->execute(context);
    }
#endif
}


void MiniBundle::execute(ClientExecutionContext *context) const
{
#ifdef __PEEKABOT_CLIENT
    for( std::size_t i = 0; i < m_actions.size(); ++i )
    {
        m_actions[i]->execute(context);
    }
#endif
}


void MiniBundle::add_action(Action *action)
{
    add_action(boost::shared_ptr<Action>(action));
}


void MiniBundle::add_action(boost::shared_ptr<Action> action)
{
    assert( action.get() != this );
    m_actions.push_back(action);
}

void MiniBundle::save(SerializationInterface &ar) const
{
    ar << m_actions;
}

void MiniBundle::load(DeserializationInterface &ar)
{
    ar >> m_actions;
}
