/*
 * Copyright Staffan Gimåker 2008-2009.
 *
 * ---
 *
 * Distributed under the Boost Software License, Version 1.0.
 * (See accompanying file LICENSE_1_0.txt or copy at
 * http://www.boost.org/LICENSE_1_0.txt)
 */

#ifndef PEEKABOT_GET_CHILDREN_HH_INCLUDED
#define PEEKABOT_GET_CHILDREN_HH_INCLUDED


#include <exception>
#include "../Types.hh"
#include "../Action.hh"


namespace peekabot
{
    /**
     * \brief This action fetches the orientation of an object and returns
     * it to the source proxy - it is not intended for usage by components other
     * than the proxy.
     */
    class GetChildren : public Action
    {
        PEEKABOT_SERIALIZABLE

    public:
        GetChildren(uint32_t request_id, ObjectID target) throw();

        virtual ~GetChildren() throw();

        virtual Action *clone() const;

        virtual void execute(
            ServerExecutionContext *context) 
            const throw(std::exception);

    private:
        GetChildren() throw();

        GetChildren(const GetChildren &x) throw();

    protected:
        void save(SerializationInterface &ar) const;

        void load(DeserializationInterface &ar);

    private:
        uint32_t m_request_id;
        ObjectID m_target;
    };
}


// PEEKABOT_REGISTER_SERIALIZABLE 62


#endif // PEEKABOT_GET_CHILDREN_HH_INCLUDED
