/*
 * Copyright Staffan Gimåker 2008-2009.
 *
 * Distributed under the Boost Software License, Version 1.0.
 * (See accompanying file LICENSE_1_0.txt or copy at
 * http://www.boost.org/LICENSE_1_0.txt)
 */

#ifndef PEEKABOT_CLEAR_CHILDREN_HH_INCLUDED
#define PEEKABOT_CLEAR_CHILDREN_HH_INCLUDED


#include <exception>
#include "../Types.hh"
#include "../Action.hh"


namespace peekabot
{
    class ClearChildren : public Action
    {
        PEEKABOT_SERIALIZABLE

    public:
        ClearChildren(ObjectID id) throw();

        virtual ~ClearChildren() throw();

        virtual Action *clone() const;

        virtual void execute(
            ServerExecutionContext *context)
            const throw(std::exception);

    private:
        ClearChildren() throw();

    protected:
        void save(SerializationInterface &ar) const;

        void load(DeserializationInterface &ar);

    private:
        ObjectID m_id;
    };
}


// PEEKABOT_REGISTER_SERIALIZABLE 89


#endif // PEEKABOT_CLEAR_CHILDREN_HH_INCLUDED
