/*
 * Copyright Staffan Gimåker 2006-2009.
 *
 * ---
 *
 * Distributed under the Boost Software License, Version 1.0.
 * (See accompanying file LICENSE_1_0.txt or copy at
 * http://www.boost.org/LICENSE_1_0.txt)
 */

#ifndef PEEKABOT_BUNDLE_HH_INCLUDED
#define PEEKABOT_BUNDLE_HH_INCLUDED


#include <vector>
#include <exception>
#include <boost/shared_ptr.hpp>

#include "../Types.hh"
#include "../Action.hh"


namespace peekabot
{
    /**
     * \brief An action that ensures that all actions added to it are executed
     * in the same frame.
     *
     * If the remainder of the actions are executed after an action fails can
     * be configured at construction.
     *
     * A beneficial side effect of using bundles is that the overhead per
     * action is reduced to \f$2+\frac{10}{N}\f$ bytes/action, where N is the
     * number of actions contained in the bundle, instead of 6
     * bytes/action.
     */
    class Bundle : public Action
    {
        PEEKABOT_SERIALIZABLE

    public:
        Bundle() throw();

        virtual ~Bundle() throw();

        virtual Action *clone() const;

        virtual void execute(
            ServerExecutionContext *context)
            const throw(std::exception);

        virtual void execute(
            ClientExecutionContext *context)
            const throw(std::exception);

        void add_action(boost::shared_ptr<Action> action) throw();

    private:
        Bundle(const Bundle &bundle) throw();

    protected:
        void save(SerializationInterface &ar) const;

        void load(DeserializationInterface &ar);

    private:
        std::vector<boost::shared_ptr<Action> > m_actions;
    };
}


// PEEKABOT_REGISTER_SERIALIZABLE 10


#endif // PEEKABOT_BUNDLE_HH_INCLUDED
