/*
 * Copyright Staffan Gimåker 2006-2010.
 *
 * ---
 *
 * This file is part of peekabot.
 *
 * peekabot is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * peekabot is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef PEEKABOT_SERVER_EXECUTION_CONTEXT_HH_INCLUDED
#define PEEKABOT_SERVER_EXECUTION_CONTEXT_HH_INCLUDED


#include "Types.hh"
#include "Any.hh"

#include <string>
#include <vector>
#include <exception>
#include <boost/filesystem/path.hpp>


namespace peekabot
{
    class Action;
    class SceneTree;
    class ActionSource;
    class Config;
    class Path;
    class SceneObject;

    class ServerExecutionContext
    {
    public:
        class UniquenessViolation : public std::exception
        {
            std::string m_name;

        public:
            UniquenessViolation(const std::string &name) throw()
                : m_name(name) {}

            virtual ~UniquenessViolation() throw() {}

            virtual const char *what() const throw()
            {
                return "Failed to add object, due to the name uniquness constraint.";
            }

            const std::string &get_name() const throw()
            {
                return m_name;
            }
        };


        ServerExecutionContext(
            const Config &config,
            SceneTree &scene,
            ActionSource &action_source);

        const Config &get_config() const;

        /**
         * \brief Turn a raw path into a path uses per client search
         * directories and client-uploaded files.
         */
        Path make_data_path(const std::string &path) const;

        void add_remote_file(
            const std::string &remote_filename,
            const void *data, std::size_t n);

        void remove_remote_file(const std::string &remote_filename);

        SceneObject *get_root() throw();

        SceneObject *get_object(ObjectID id) throw();

        template<class T>
        T *get_object(ObjectID id) throw()
        {
            return dynamic_cast<T *>(get_object(id));
        }

        SceneObject *get_object(
            const std::string &path,
            SceneObject *path_parent = 0) throw();

        void register_pseudonym(ObjectID real_id, ObjectID pseudonym_id) throw(std::exception);

        void deregister_pseudonym(ObjectID pseudonym_id) throw(std::exception);

        //void post_action(Action *action, const SourceID &dest) throw();

        void post_response(Action *action) throw();

        std::vector<SceneObject *> load_scene(const Path &path);

        SceneObject *create_object(
            ObjectType type, const std::vector<Any> &args);

    private:
        const Config &m_config;
        SceneTree &m_scene;
        ActionSource &m_action_source;
    };
}


#endif // PEEKABOT_SERVER_EXECUTION_CONTEXT_HH_INCLUDED
