/*
 * Copyright Staffan Gimåker 2010.
 *
 * ---
 *
 * This file is part of peekabot.
 *
 * peekabot is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * peekabot is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef PEEKABOT_SERVER_HH_INCLUDED
#define PEEKABOT_SERVER_HH_INCLUDED


#include <queue>
#include <string>
#include <boost/function.hpp>
#include <boost/utility.hpp>
#include <boost/asio.hpp>
#include <boost/thread/mutex.hpp>
#include <boost/thread/condition.hpp>
#include <boost/thread/thread.hpp>


namespace peekabot
{
    class Config;
    class ClientConnection;
    class Action;
    class SceneTree;

    struct ServerData
    {
        SceneTree *m_scene;
    };

    /**
     * \internal
     *
     * \brief Provides a split-phase interface for accessing data in the
     * server, such as the scene.
     */
    class Server : public boost::noncopyable
    {
    public:
        Server(const Config &config);

        ~Server();

        const Config &get_config() const;

        void start();

        void stop();

        bool is_stopped() const;

        void post(boost::function<void (ServerData &)> handler);

        // For recording actions
        //void announce_action(boost::shared_ptr<Action>);

        void listen_ipv4(unsigned int port);

        //boost::range<...> get_clients();

    private:
        void start_accept(
            boost::shared_ptr<boost::asio::ip::tcp::acceptor> acceptor);

        void handle_accept(
            const boost::system::error_code &e,
            boost::shared_ptr<boost::asio::ip::tcp::acceptor> acceptor,
            boost::shared_ptr<ClientConnection> c);

        void server_thread();

    private:
        const Config &m_config;

        ServerData m_data;

        typedef std::queue<
            boost::function<void (ServerData &)> > RequestQueue;
        RequestQueue m_requests;
        boost::mutex m_requests_mutex;
        boost::condition m_requests_cond;

        boost::asio::io_service m_io_service;
        boost::asio::io_service::work *m_work;

        boost::thread *m_asio_thread;
        boost::thread *m_server_thread;
        volatile bool m_stop_signal;
    };
}


#endif // PEEKABOT_SERVER_HH_INCLUDED
