/*
 * This file is part of peekabot.
 *
 * peekabot is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * peekabot is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef __PEEKABOT_SCENE_TREE_PTR_HH
#define __PEEKABOT_SCENE_TREE_PTR_HH


#include "SceneTree.hh"


namespace peekabot
{


    class TheSceneTree;


    class SceneTreePtr
    {
        friend class TheSceneTree;

        SceneTree *m_scene_tree;

        SceneTree::SceneTreeMutex::scoped_lock *m_lock;

        explicit SceneTreePtr(SceneTree *scene_tree)
            : m_scene_tree(scene_tree),
              m_lock(new SceneTree::SceneTreeMutex::scoped_lock(scene_tree->m_scene_mutex))
        {
        }

    public:

        SceneTreePtr() throw() : m_scene_tree(0), m_lock(0) {}

        ~SceneTreePtr() throw()
        {
            if( m_lock )
                delete m_lock;
        }

        /*explicit SceneTreePtr(SceneTreePtr &ptr) throw()
        {
            m_scene_tree = ptr.m_scene_tree;
            m_lock = ptr.m_lock;

            ptr.m_scene_tree = 0;
            ptr.m_lock = 0;
        }*/

        SceneTreePtr &operator=(SceneTreePtr &ptr) throw()
        {
            m_scene_tree = ptr.m_scene_tree;
            m_lock = ptr.m_lock;

            ptr.m_scene_tree = 0;
            ptr.m_lock = 0;

            return *this;
        }


        SceneTree *operator->() throw()
        {
            return m_scene_tree;
        }
    };



    class TheSceneTree
    {
    public:
        static SceneTreePtr acquire() throw()
        {
            static SceneTree scene_tree;

            return SceneTreePtr(&scene_tree);
        }
    };


}


#endif // __PEEKABOT_SCENE_TREE_PTR_HH
