/*
 * Copyright Staffan Gimåker 2006-2010.
 * Copyright Anders Boberg 2006-2007.
 *
 * ---
 *
 * This file is part of peekabot.
 *
 * peekabot is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * peekabot is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include "PolygonObject.hh"
#include "ObjectVisitor.hh"
#include "ScopedHandler.hh"
#include "ScopedMap.hh"
#include "ObjectTypes.hh"


using namespace peekabot;


HandlerInformer PolygonObject::ms_handler_informer(
    "polygon",
    &PolygonObject::start_handler);


PolygonObject::PolygonObject()
    : SceneObject("polygon"),
      VertexObject(1)
{
}


PolygonObject::PolygonObject(ScopedHandler* handler)
    : SceneObject("polygon", handler),
      ScalableObject(handler),
      VertexObject(handler, 1)
{
}


void PolygonObject::accept(ObjectVisitor* visitor) throw()
{
    visitor->visit(this);
}


ObjectType PolygonObject::get_object_type() const
{
    return POLYGON_OBJECT;
}


PropMap &PolygonObject::get_prop_adapters()
{
    static PropMap *s_prop_adapters = 0;
    if( !s_prop_adapters )
    {
        s_prop_adapters = new PropMap;
        merge_prop_adapters(
            *s_prop_adapters, SceneObject::get_prop_adapters());
        merge_prop_adapters(
            *s_prop_adapters, ScalableObject::get_prop_adapters());
        merge_prop_adapters(
            *s_prop_adapters, VertexObject::get_prop_adapters());
    }

    return *s_prop_adapters;
}


void PolygonObject::start_handler(
    const std::string & name,
    ScopedHandler::AttributeMap &attributes,
    ScopedHandler *handler) throw()
{
    // Creating a scene object by passing a ScopedHandler will cause it to
    // enter a new scope with all registered tag start handlers plus any
    // specific handlers for SceneObject properties which are registered
    // by the parent constructor.
    SceneObject* tmp = new PolygonObject(handler);

    // Set the new object as the current object
    ScopedMap & variables = handler->get_variables();
    variables.push_variable("current_object", tmp);
}
