/*
 * Copyright Staffan Gimåker 2008-2010.
 *
 * ---
 *
 * This file is part of peekabot.
 *
 * peekabot is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * peekabot is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef PEEKABOT_POINT_CLOUD_HH_INCLUDED
#define PEEKABOT_POINT_CLOUD_HH_INCLUDED


#include "SceneObject.hh"
#include "ScalableObject.hh"
#include "VertexObject.hh"
#include "ObjectVisitor.hh"
#include "HandlerInformer.hh"


namespace peekabot
{
    class ScopedHandler;

    /**
     * \internal
     *
     * \brief Primitive for efficient representation of point clouds.
     */
    class PointCloud : public SceneObject,
                       public ScalableObject,
                       public VertexObject
    {
    public:
        /**
         * \brief Creates a new empty point cloud primitive.
         */
        PointCloud() throw();

        /**
         * \brief Construct a point cloud primitive from XML data.
         */
        PointCloud(ScopedHandler *handler);

        /**
         * \brief Method for accepting \c ObjectVisitor objects.
         *
         * This method performs an automatic type cast by calling the \c visit()
         * method of the visitor, allowing it to perform type-dependent task.
         */
        virtual void accept(ObjectVisitor* visitor) throw();

        virtual ObjectType get_object_type() const;

    protected:
        virtual PropMap &get_prop_adapters();

    private:
        /// \name XML handler methods
        /// @{

        /**
         * \brief Element start handler for XML parsing.
         */
        static void start_handler(
            const std::string & name,
            XMLHandler::AttributeMap &attributes,
            ScopedHandler *handler) throw();

        /// @}

    private:
        static HandlerInformer ms_handler_informer;
    };
}


#endif // PEEKABOT_POINT_CLOUD_HH_INCLUDED
