/*
 * Copyright Staffan Gimåker 2009
 *
 * ---
 *
 * Distributed under the Boost Software License, Version 1.0.
 * (See accompanying file LICENSE_1_0.txt or copy at
 * http://www.boost.org/LICENSE_1_0.txt)
 */

#ifndef PEEKABOT_PBAR_PLAYER_HH_INCLUDED
#define PEEKABOT_PBAR_PLAYER_HH_INCLUDED


#include <queue>
#include <boost/function.hpp>
#include <boost/scoped_ptr.hpp>
#include <boost/thread.hpp>
#include <boost/thread/recursive_mutex.hpp>
#include <boost/thread/condition.hpp>
#include <boost/date_time/posix_time/posix_time.hpp>

#include "Types.hh"
#include "PbarReader.hh"


namespace peekabot
{
    class PbarReader;
    class Action;

    class PbarPlayer
    {
    public:
        PbarPlayer(
            const std::string &filename,
            boost::function<void (boost::shared_ptr<Action>)> dispatch_fun);

        ~PbarPlayer();

        void play();

        void pause();

        bool is_paused() const;

        bool is_finished() const;

        void step(size_t n);

        void step(const boost::posix_time::time_duration &td);

        void set_playback_speed(double factor);

        double get_playback_speed() const;

        bool is_multi_client_recording() const;

        boost::posix_time::time_duration elapsed() const;

        boost::posix_time::time_duration duration() const;

        size_t action_count() const;

    private:
        void run();

        void buffer();

    private:
        boost::function<void (boost::shared_ptr<Action>)> m_dispatch_fun;

        PbarReader m_reader;

        bool m_paused;
        double m_playback_spd;
        boost::posix_time::time_duration m_elapsed;

        mutable boost::recursive_mutex m_mutex;

        boost::condition m_play_cond;


        typedef std::pair<
            boost::posix_time::time_duration,
            boost::shared_ptr<Action> > TimestampedAction;
        std::queue<TimestampedAction> m_buffer;


        boost::thread *m_thread;
        mutable boost::recursive_mutex m_service_mutex;
        volatile bool m_stop_signal;
    };
}


#endif // PEEKABOT_PBAR_PLAYER_HH_INCLUDED
