/*
 * Copyright Staffan Gimåker 2008-2010.
 *
 * ---
 *
 * This file is part of peekabot.
 *
 * peekabot is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * peekabot is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include "ObjectVisitor.hh"
#include "ScopedHandler.hh"
#include "ScopedMap.hh"
#include "LineCloud.hh"
#include "ObjectTypes.hh"

#include <limits>


using namespace peekabot;


HandlerInformer LineCloud::ms_handler_informer(
    "line_cloud", &LineCloud::start_handler);


LineCloud::LineCloud() throw()
    : SceneObject("line_cloud"),
      VertexObject(2)
{
}


LineCloud::LineCloud(ScopedHandler *handler)
    : SceneObject("line_cloud", handler),
      ScalableObject(handler),
      VertexObject(handler, 2),
      LineBased(handler)
{
}


void LineCloud::accept(ObjectVisitor* visitor) throw()
{
    visitor->visit(this);
}


ObjectType LineCloud::get_object_type() const
{
    return LINE_CLOUD_OBJECT;
}


PropMap &LineCloud::get_prop_adapters()
{
    static PropMap *s_prop_adapters = 0;
    if( !s_prop_adapters )
    {
        s_prop_adapters = new PropMap;
        merge_prop_adapters(
            *s_prop_adapters, SceneObject::get_prop_adapters());
        merge_prop_adapters(
            *s_prop_adapters, ScalableObject::get_prop_adapters());
        merge_prop_adapters(
            *s_prop_adapters, LineBased::get_prop_adapters());
        merge_prop_adapters(
            *s_prop_adapters, VertexObject::get_prop_adapters());
    }

    return *s_prop_adapters;
}


void LineCloud::start_handler(
    const std::string & name,
    XMLHandler::AttributeMap &attributes,
    ScopedHandler *handler) throw()
{
    // Creating a scene object by passing a ScopedHandler will cause it to
    // enter a new scope with all registered tag start handlers plus any
    // specific handlers for SceneObject properties which are registered
    // by the parent constructor.
    SceneObject* tmp = new LineCloud(handler);

    // Set the new object as the current object
    ScopedMap & variables = handler->get_variables();
    variables.push_variable("current_object", tmp);
}
